package zigen.plugin.db.ext.jdt.ui;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import zigen.plugin.db.ext.jdt.ui.Messages;

public class PackageSelectDialog extends TitleAreaDialog {

	private TreeViewer viewer;

	private PackageFragment packageFragment;

	private String defaultProject;

	private String title = Messages.getString("PackageSelectDialog.0"); //$NON-NLS-1$

	public PackageSelectDialog(Shell parentShell, String title) {
		super(parentShell);
		this.title = title;
		parentShell.setText(title);
	}

	public PackageSelectDialog(Shell parentShell, String title, String defaultProject) {
		this(parentShell, title);
		this.defaultProject = defaultProject;
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(title);
	}

	protected Control createDialogArea(Composite parent) {
		super.setTitle(title);
		super.setMessage(Messages.getString("PackageSelectDialog.1"), IMessageProvider.NONE); //$NON-NLS-1$

		Composite composite = (Composite) super.createDialogArea(parent);

		Composite composite2 = new Composite(composite, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.FILL_BOTH));

		FillLayout layout = new FillLayout();
		composite2.setLayout(layout);

		viewer = new TreeViewer(composite2, SWT.BORDER);

		viewer.setContentProvider(new StandardJavaElementContentProvider());

		viewer.addFilter(new SourceDirViewerFilter());

		JavaElementLabelProvider provider = new JavaElementLabelProvider();
		viewer.setLabelProvider(provider);

        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IJavaModel javaModel = JavaCore.create(root);
		viewer.setInput(javaModel);

		if (defaultProject != null)
			expandDefaultProject(javaModel, defaultProject);

		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				selectionChangeHandler(event);
			}
		});

		return composite;
	}

	private void expandDefaultProject(IJavaModel javaModel, String defaultProject) {
		IJavaProject jProject = javaModel.getJavaProject(defaultProject);

		if (jProject != null && jProject.exists()) {
			IJavaProject myJavaProject = javaModel.getJavaProject(defaultProject);
			viewer.expandToLevel(myJavaProject, 2);

		}
	}

	protected Control createContents(Composite parent) {
		Control ctl = super.createContents(parent);
		getButton(IDialogConstants.OK_ID).setEnabled(false);
		return ctl;
	}

	private void selectionChangeHandler(SelectionChangedEvent event) {
		Object obj = (Object) ((StructuredSelection) event.getSelection()).getFirstElement();

		if (obj instanceof PackageFragment) {
			packageFragment = (PackageFragment) obj;
			getButton(IDialogConstants.OK_ID).setEnabled(true);

		} else {
			packageFragment = null;
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}

	}

	protected Point getInitialSize() {
		return new Point(480, 450);
	}

	public PackageFragment getPackageFragment() {
		return packageFragment;
	}
}
